/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.calendar;

import de.willuhn.jameica.gui.calendar.Appointment;
import de.willuhn.jameica.gui.internal.action.ReminderAppointmentDetails;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.util.ApplicationException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;

public class ReminderAppointment
implements Appointment {
    public static final String QUEUE = "jameica.reminder.appointment";
    public static final String KEY_NAME = "key.name";
    public static final String KEY_DESCRIPTION = "key.description";
    private String uuid = null;
    private Reminder reminder = null;
    private Date date = null;

    public ReminderAppointment(String uuid, Reminder reminder) {
        this(uuid, reminder, null);
    }

    public ReminderAppointment(String uuid, Reminder reminder, Date date) {
        this.uuid = uuid;
        this.reminder = reminder;
        this.date = date;
    }

    @Override
    public Date getDate() {
        return this.date != null ? this.date : this.reminder.getDate();
    }

    @Override
    public String getName() {
        return (String)((Object)this.getData().get(KEY_NAME));
    }

    @Override
    public String getDescription() {
        return (String)((Object)this.getData().get(KEY_DESCRIPTION));
    }

    @Override
    public void execute() throws ApplicationException {
        new ReminderAppointmentDetails().handleAction(this);
    }

    @Override
    public RGB getColor() {
        Date executed = (Date)this.reminder.getData("jameica.reminder.key.executed");
        ReminderInterval ri = this.reminder.getReminderInterval();
        RGB black = Color.BLACK.getSWTColor().getRGB();
        RGB gray = Color.COMMENT.getSWTColor().getRGB();
        if (executed == null) {
            return black;
        }
        if (ri == null) {
            return gray;
        }
        return executed.after(this.getDate()) ? gray : black;
    }

    @Override
    public boolean hasAlarm() {
        return true;
    }

    @Override
    public String getUid() {
        return this.uuid;
    }

    public Reminder getReminder() {
        return this.reminder;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    private Map<String, Serializable> getData() {
        return this.reminder.getData();
    }
}

